package lac.contextnet.sddl_longrunningtest;

import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

import lac.contextnet.sddl_longrunningtest.adapters.MainFragmentAdapter;
import lac.contextnet.sddl_longrunningtest.adapters.SmartphoneAdapter;
import lac.contextnet.sddl_longrunningtest.adapters.SmartphoneModel;
import lac.contextnet.sddl_longrunningtest.service.ConnectionListener;
import lac.contextnet.sddl_longrunningtest.service.ConnectionService;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.Menu;
import android.view.View;
import android.widget.TextView;

import com.aspsine.fragmentnavigator.FragmentNavigator;
import com.infopae.model.SDDLLocation;
import com.luseen.spacenavigation.SpaceItem;
import com.luseen.spacenavigation.SpaceNavigationView;
import com.luseen.spacenavigation.SpaceOnClickListener;

public class MainActivity extends AppCompatActivity {

	SpaceNavigationView spaceNavigationView;
	private FragmentNavigator mNavigator;
	public static SmartphoneAdapter adapter;

	Intent iService, iIPAct;

	final Handler uiHandler = new Handler();

	Timer uiTimer;
	TimerTask uiTimerTask;

	int screenRefreshRate = 3000;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		mNavigator = new FragmentNavigator(getSupportFragmentManager(), new MainFragmentAdapter(), R.id.container);
		mNavigator.setDefaultPosition(0);
		mNavigator.onCreate(savedInstanceState);
		adapter = new SmartphoneAdapter(getApplicationContext());

		spaceNavigationView = (SpaceNavigationView) findViewById(R.id.space);
		spaceNavigationView.initWithSaveInstanceState(savedInstanceState);
		spaceNavigationView.addSpaceItem(new SpaceItem("MAPA", R.drawable.ic_location));
		spaceNavigationView.addSpaceItem(new SpaceItem("SMARTPHONES", R.drawable.ic_phone));
		if(AppConfig.getService(getApplicationContext()))
			spaceNavigationView.setCentreButtonIcon(R.drawable.ic_face_sad);
		else
			spaceNavigationView.setCentreButtonIcon(R.drawable.ic_face_happy);

		spaceNavigationView.setSpaceOnClickListener(new SpaceOnClickListener() {
			@Override
			public void onCentreButtonClick() {
				if(!AppConfig.getService(getApplicationContext())) {
					Log.d("SDDL", "Start Clicked");
					if (!hasIpAndPort()) {
						startActivity(iIPAct);
					} else {
						startService(iService);

						AppConfig.setService(getApplicationContext(), true);
						spaceNavigationView.changeCenterButtonIcon(R.drawable.ic_face_sad);
					}
				}
				else
				{
					Log.d("SDDL", "Stop Clicked");
					stopService(iService);
					AppConfig.setService(getApplicationContext(), false);
					spaceNavigationView.changeCenterButtonIcon(R.drawable.ic_face_happy);
				}
			}

			@Override
			public void onItemClick(int itemIndex, String itemName) {
				setCurrentTab(itemIndex);
			}

			@Override
			public void onItemReselected(int itemIndex, String itemName) {

			}
		});

		iService = new Intent(this, ConnectionService.class);
		iIPAct = new Intent(this, ipActivity.class);

		iService.putExtra("uuid","");

		setCurrentTab(mNavigator.getCurrentPosition());
	}

	private void setCurrentTab(int position) {
		mNavigator.showFragment(position);
	}

	@Override
	protected void onStart() {
		super.onStart();
		//startTimer();
	}

	@Override
	protected void onResume() {
		super.onResume();
		//startTimer();
	}
	
	/*start the timer*/
	private void startTimer () {
		uiTimerTask = new TimerTask() {
			public void run () {
				updateUi();
			}
		};
		uiTimer = new Timer();
		uiTimer.schedule(uiTimerTask, 0, screenRefreshRate);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	/* check if there is an IP and Port on the config file */
	private Boolean hasIpAndPort () {
		String ip = AppConfig.getIpPort(getApplicationContext());
		if (AppConfig.isValidIpPort(ip))
			return true;
		return false;
	}
	
	/* print information on screen about ip and service */
	private void updateUi () {
		uiHandler.post(uiRunnable);
	}
	
	//Runnable to update the UI
	final Runnable uiRunnable = new Runnable() {
		public void run () {
			SharedPreferences config = getSharedPreferences(AppConfig.PREF_FILE, Context.MODE_PRIVATE);

			String ipAndPort = config.getString(AppConfig.IP_AND_PORT, "");
			//txtIP.setText("IP: "+ipAndPort);

		}
	};

	@Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);
		spaceNavigationView.onSaveInstanceState(outState);
	}

	@Override
	protected void onPause() {
		//stop timer
		//uiTimer.cancel();
		super.onPause();
	};

	@Override
	protected void onStop() {
		//stop timer
		//uiTimer.cancel();
		super.onStop();
	};
}
